from django import forms
from .models import *
from .models import Role

from django.contrib import admin
from django.contrib.auth.models import User
from django.forms import modelformset_factory
from jalali_date.widgets import AdminJalaliDateWidget, AdminSplitJalaliDateTime
from django.utils.safestring import mark_safe

class BaseForm(forms.ModelForm):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        for field in self.fields.values():
            field.widget.attrs.update({'class': 'form-control'})

class LoginForm(forms.Form):
    username = forms.CharField(
        label='نام کاربری',
        max_length=100,
        widget=forms.TextInput(attrs={
            'class': 'form-control',
            'placeholder': 'نام کاربری'
        })
    )
    password = forms.CharField(
        label='رمز عبور',
        widget=forms.PasswordInput(attrs={
            'class': 'form-control',
            'placeholder': 'رمز عبور'
        })
    )

class RoleForm(forms.ModelForm):
    class Meta:
        model = Role
        fields = '__all__'

class RingForm(BaseForm):
    class Meta:
        model = Ring
        fields = '__all__'

class RingMemberForm(BaseForm):
    class Meta:
        model = RingMember
        fields = '__all__'

class RingMemberForm1(BaseForm):
    class Meta:
        model = RingMember
        fields = ['person']  # فقط فیلد 'person' را نشان می‌دهیم و 'ring' را حذف می‌کنیم

class ReportCardForm(forms.ModelForm):
    class Meta:
        model = ReportCard
        fields = '__all__'

class ReportCardDetailForm(forms.ModelForm):
    class Meta:
        model = ReportCardDetail
        fields = '__all__'

class PersonForm(forms.ModelForm):
    class Meta:
        model = Person
        fields = ['national_code', 'role']

    national_code = forms.CharField(max_length=10, label="کد ملی", widget=forms.TextInput(attrs={'class': 'form-control'}))
    role = forms.ModelMultipleChoiceField(
        queryset=Role.objects.all(),
        widget=forms.CheckboxSelectMultiple(attrs={'class': 'form-check-inline'}),
        label="نقش"
    )

class PersonPrivateInfoForm(forms.ModelForm):
    class Meta:
        model = PersonPrivateInfo
        fields = ['birthday',   'birth_place', 'gender', 
                  'phone', 'father_name', 'father_phone', 'fatherIsAlive', 
                  'father_grade', 'fatherJob', 'motherIsAlive', 
                  'mother_phone', 'mother_name', 'mother_grade', 'motherJob']
    
        widgets = {
            'birthday': AdminJalaliDateWidget(),
              # استفاده از ویجت تاریخ شمسی
            # برای تاریخ و زمان می‌توانید از AdminSplitJalaliDateTime استفاده کنید:
            # 'date_run': AdminSplitJalaliDateTime(),
        }

    birth_place = forms.CharField(max_length=100, label="محل تولد", required=False)
    gender = forms.ChoiceField(choices=PersonPrivateInfo.GENDER_CHOICES, label="جنسیت", required=False)
    phone = forms.CharField(max_length=11, label="شماره موبایل", required=False)
    father_name = forms.CharField(max_length=110, label="نام پدر*")
    father_phone = forms.CharField(max_length=11, label="شماره تماس پدر", required=False)
    fatherIsAlive = forms.ChoiceField(choices=PersonPrivateInfo.Ansewr_CHOICE, label="پدر در قید حیات است؟", required=False)
    father_grade = forms.ChoiceField(choices=PersonPrivateInfo.EDU_CHOICES, label="تحصیلات پدر", required=False)
    fatherJob = forms.CharField(max_length=150, label="شغل پدر", required=False)
    motherIsAlive = forms.ChoiceField(choices=PersonPrivateInfo.Ansewr_CHOICE, label="مادر در قید حیات است؟", required=False)
    mother_phone = forms.CharField(max_length=11, label="شماره تماس مادر", required=False)
    mother_name = forms.CharField(max_length=150, label="نام مادر", required=False)
    mother_grade = forms.ChoiceField(choices=PersonPrivateInfo.EDU_CHOICES, label="تحصیلات مادر", required=False)
    motherJob = forms.CharField(max_length=150, label="شغل مادر", required=False)

class PersonEDUForm(forms.ModelForm):
    class Meta:
        model = PersonEDU
        fields = ['typee', 'place_name', 'edu_name', 'term_name', 'otherClass', 'place_address']

    typee = forms.ChoiceField(choices=PersonEDU.EDU_CHOICES, label="وضعیت تحصیلی")
    place_name = forms.CharField(max_length=250, label="نام محل تحصیل", required=False)
    edu_name = forms.CharField(max_length=250, label="رشته تحصیلی", required=False)
    term_name = forms.CharField(max_length=250, label="ترم/پایه تحصیلی", required=False)
    otherClass = forms.CharField(max_length=300, widget=forms.Textarea, label="کلاس خارج از مدرسه", required=False)
    place_address = forms.CharField(widget=forms.Textarea, label="آدرس محل تحصیل", required=False)

class PersonOtherInfoForm(forms.ModelForm):
    class Meta:
        model = PersonOtherInfo
        fields = [ 'family_count', 'numberOfChild', 'wife_type', 
                  'is_employed', 'job_type', 'job_title', 'salary_month', 'talents']

    
    family_count = forms.IntegerField(label="تعداد اعضای خانواده", required=False)
    numberOfChild = forms.IntegerField(label="فرزند چندم", required=False)
    wife_type = forms.ChoiceField(choices=PersonOtherInfo.WIFE_CHOICES, label="وضعیت تاهل")
    is_employed = forms.ChoiceField(choices=PersonOtherInfo.Ansewr_CHOICE, label="شاغل است؟", required=False)
    job_type = forms.CharField(max_length=50, label="نوع شغل", required=False)
    job_title = forms.CharField(max_length=250, label="عنوان شغل", required=False)
    salary_month = forms.IntegerField(label="میزان درآمد ماهانه(تومان)", required=False)
    talents = forms.CharField(widget=forms.Textarea, label="استعداد و توانایی‌ها", required=False)

class PersonAddressForm(forms.ModelForm):
    class Meta:
        model = PersonAddress
        fields = ['id' ,'typee','address','postal_code','tell','location']
        widgets = {
            'id': forms.HiddenInput(),  # پنهان کردن فیلد id
        }
PersonAddressFormSet = modelformset_factory(PersonAddress, form=PersonAddressForm, can_delete=True)

class PersonCulturalForm(forms.ModelForm):
    class Meta:
        model = PersonCultural
        fields = ['raste_categories','ozviat_categories','tarbyat_categories','sardoshi_categories','date_enter',
                  'first_major_name' , 'enter_type','description']
        widgets = {
            'date_enter': AdminJalaliDateWidget(), 
            

        }
        
class UserForm(forms.ModelForm):
    class Meta :
        model = User
        fields = ['first_name' , 'last_name' , 'username']

class PersonPicForm(forms.ModelForm):
    class Meta:
        model = PersonPrivateInfo
        fields = ['pic']  # فقط فیلد pic انتخاب می‌شو
    pic = forms.ImageField(label="آپلود عکس")

class PersonPsyForm(forms.ModelForm):
    class Meta:
        model = PersonCultural
        fields = ['Psychological_test']  # فقط فیلد pic انتخاب می‌شو
    Psychological_test = forms.FileField(label="آپلود فایل تست شخصیت")


class ReportCardForm(forms.ModelForm):
    class Meta:
        model = ReportCard
        fields = ['person', 'date', 'title','ring']
        widgets = {
            'date': forms.Select(),
            'title': forms.Select()
        }

class ReportCardDetailForm(forms.ModelForm):
    class Meta:
        model = ReportCardDetail
        fields = [ 'score']
        
class IndexForm(forms.ModelForm):
    class Meta:
        model = Index
        fields = ['title', 'coefficient']
        labels = {
            'title': 'عنوان',
            'coefficient': 'ضریب',
        }
        widgets = {
            'title': forms.TextInput(attrs={'class': 'form-control', 'placeholder': 'عنوان را وارد کنید'}),
            'coefficient': forms.NumberInput(attrs={'class': 'form-control', 'placeholder': 'ضریب را وارد کنید'}),
        }
from django import forms
from django import forms
from django.core.exceptions import ValidationError
import re

class VerifyIdentityForm(forms.Form):
    national_id = forms.CharField(label="کد ملی", max_length=10, required=True)
    birth_date = forms.CharField(
        label="تاریخ تولد",
        required=True
    )
    father_name = forms.CharField(label="نام پدر", required=True)

    def clean_birth_date(self):
        birth_date = self.cleaned_data['birth_date']
        date_pattern = r"^\d{4}-\d{2}-\d{2}$"  # YYYY-MM-DD format
        
        if not re.match(date_pattern, birth_date):
            raise ValidationError("فرمت تاریخ باید YYYY-MM-DD باشد.")
        return birth_date

class ResetPasswordForm(forms.Form):
    new_password = forms.CharField(label="رمز عبور جدید", widget=forms.PasswordInput, required=True)
    confirm_password = forms.CharField(label="تکرار رمز عبور", widget=forms.PasswordInput, required=True)

class FamilyForm(forms.ModelForm):
    class Meta:
        model = Family
        fields = ['individual', 'child', ]
      

    