from .models import Role
def user_roles(request):
    if not request.user.is_authenticated:
        # اگر کاربر لاگین نباشد، تمام نقش‌ها False هستند
        roles_status = {role[0]: False for role in Role.ROLE_CHOICES}
        return {'roles_status': roles_status}

    person = getattr(request.user, 'person', None)
    if person:
        # بررسی نقش‌های کاربر
        user_roles = person.role.values_list('name', flat=True)
        roles_status = {role[0]: role[0] in user_roles for role in Role.ROLE_CHOICES}
    else:
        # اگر شخصی برای کاربر تعریف نشده باشد
        roles_status = {role[0]: False for role in Role.ROLE_CHOICES}

    return {'roles_status': roles_status}



