# Generated by Django 4.2 on 2025-02-12 14:19

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import django_jalali.db.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('persons', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ActivityDetails',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('microActivity', models.CharField(blank=True, max_length=250, null=True, verbose_name='ریزفعالیت')),
                ('ratio', models.IntegerField(default=1, verbose_name='ضریب')),
                ('done', models.BooleanField(default=False, verbose_name='انجام شده؟')),
                ('description', models.CharField(blank=True, max_length=500, verbose_name='توضیحات')),
                ('time', django_jalali.db.models.jDateField(blank=True, null=True, verbose_name='تاریخ')),
                ('is_reset', models.BooleanField(default=False, verbose_name='ریست شده؟')),
            ],
            options={
                'verbose_name': 'ریزفعالیت',
                'verbose_name_plural': 'ریزفعالیت\u200cها',
            },
        ),
        migrations.CreateModel(
            name='Council',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250, verbose_name='نام جلسه')),
                ('meeting_place', models.CharField(blank=True, max_length=150, null=True, verbose_name='مکان جلسه')),
                ('date_run', django_jalali.db.models.jDateField(blank=True, null=True, verbose_name='تاریخ جلسه')),
                ('description', models.CharField(blank=True, max_length=55, null=True, verbose_name='توضحیات')),
                ('persons', models.ManyToManyField(blank=True, null=True, to='persons.person', verbose_name='افراد حاظر در جلسه')),
            ],
            options={
                'verbose_name': 'جلسه شورا',
                'verbose_name_plural': 'جلسات شورا',
            },
        ),
        migrations.CreateModel(
            name='CouncilApprovals',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=350, verbose_name='عنوان مصوبه')),
                ('file', models.FileField(blank=True, null=True, upload_to='CouncilApprovals', verbose_name='فایل جلسه')),
                ('state', models.BooleanField(default=False, verbose_name='تصویب شده؟')),
                ('positive_pole', models.IntegerField(blank=True, null=True, verbose_name='آرای مثبت')),
                ('negativ_pole', models.IntegerField(blank=True, null=True, verbose_name='آرای منفی')),
                ('bstentions_pole', models.IntegerField(blank=True, null=True, verbose_name='آرای ممتنع')),
                ('council', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='CouncilApprovals', to='meetings.council', verbose_name='شورا')),
            ],
            options={
                'verbose_name': 'مصوبه\u200cجلسه',
                'verbose_name_plural': 'مصوبات\u200cجلسه',
            },
        ),
        migrations.CreateModel(
            name='DutiesOfUnits',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('raste_categories', models.CharField(choices=[('vazesh_va_ordoyi', 'ورزشی و اردویی'), ('heiat', 'هییت'), ('mali', 'مالی'), ('farhangi', 'فرهنگی'), ('elmi_va_amoshghari', 'علمی و آموزشی'), ('hafa', 'حفا'), ('taleem_va_tarbiyat', 'تعلیم و تربیت'), ('edari', 'اداری'), ('ejtemai', 'اجتماعی'), ('omaliat', 'عملیات')], max_length=20, verbose_name='رسته')),
                ('mainTask', models.CharField(blank=True, max_length=250, null=True, verbose_name='وظایف اصلی')),
            ],
            options={
                'verbose_name': 'وظیفه واحد',
                'verbose_name_plural': 'وظایف واحد',
            },
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255)),
                ('message', models.TextField()),
                ('is_read', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('has_evaluated', models.BooleanField(default=False)),
                ('activity_details', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='meetings.activitydetails', verbose_name='ریزفعالیت')),
                ('user', models.ManyToManyField(to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Futurework',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('not done', 'انجام نشده'), ('in progress', 'درحال انجام'), ('done', 'انجام شده')], max_length=25, verbose_name='وضعیت')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True, verbose_name='توضیحات')),
                ('is_read', models.BooleanField(default=False, verbose_name='خوانده شده')),
                ('Council', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='Futurework', to='meetings.council', verbose_name='شورا')),
                ('persons', models.ManyToManyField(blank=True, null=True, to='persons.person', verbose_name='افراد  انجام دهنده')),
                ('title', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='meetings.councilapprovals', verbose_name='عنوان')),
            ],
            options={
                'verbose_name': 'کار آینده',
                'verbose_name_plural': 'کار های آینده',
            },
        ),
        migrations.CreateModel(
            name='Evaluation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value_choices', models.FloatField(choices=[(0.0, 'غیرقابل قبول'), (0.25, 'ضعیف'), (0.5, 'متوسط'), (0.75, 'خوب'), (1.0, 'عالی')], max_length=55, verbose_name='نظر')),
                ('time', models.DateField(blank=True, default=django.utils.timezone.now, verbose_name='تاریخ')),
                ('description', models.CharField(blank=True, max_length=500, verbose_name='توضیحات')),
                ('mainTask', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='meetings.activitydetails', verbose_name='وظایف اصلی')),
                ('raste_categories', models.ForeignKey(max_length=20, on_delete=django.db.models.deletion.CASCADE, to='meetings.dutiesofunits', verbose_name='رسته')),
            ],
            options={
                'verbose_name': 'نظر',
                'verbose_name_plural': 'نظرها',
            },
        ),
        migrations.CreateModel(
            name='CouncilMembers',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('raste_categories', models.CharField(blank=True, choices=[('ورزشی و اردویی', 'ورزشی و اردویی'), ('هییت', 'هییت'), ('مالی', 'مالی'), ('فرهنگی', 'فرهنگی'), ('علمی و آموزشی', 'علمی و آموزشی'), ('حفا', 'حفا'), ('تعلیم و تربیت', 'تعلیم و تربیت'), ('اداری', 'اداری'), ('اجتماعی', 'اجتماعی'), ('عملیات', 'عملیات'), ('اداری', 'اداری')], max_length=20, null=True, verbose_name='رسته')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='persons.person', verbose_name='فرد')),
            ],
            options={
                'verbose_name': 'عضو شورا',
                'verbose_name_plural': 'اعضا شورا',
            },
        ),
        migrations.AddField(
            model_name='activitydetails',
            name='mainTask',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='meetings.dutiesofunits', verbose_name='وظایف اصلی'),
        ),
    ]
