from django import forms
from .models import *
from django_select2.forms import ModelSelect2Widget, ModelSelect2MultipleWidget
from jalali_date.fields import JalaliDateField, SplitJalaliDateTimeField
from jalali_date.widgets import AdminJalaliDateWidget, AdminSplitJalaliDateTime
from django import forms
from jalali_date.widgets import AdminJalaliDateWidget, AdminSplitJalaliDateTime
from .models import Council
from django.utils.translation import gettext_lazy as _

from django_select2.forms import ModelSelect2MultipleWidget
from .models import Futurework, Person


from django_select2.forms import ModelSelect2MultipleWidget
from django_select2.forms import Select2MultipleWidget
from django.urls import reverse_lazy

class CouncilForm(forms.ModelForm):
    class Meta:
        model = Council
        fields = ['name', 'persons', 'meeting_place', 'date_run', 'description']
        widgets = {
            'date_run': AdminJalaliDateWidget(),  # استفاده از ویجت تاریخ شمسی
            # برای تاریخ و زمان می‌توانید از AdminSplitJalaliDateTime استفاده کنید:
            # 'date_run': AdminSplitJalaliDateTime(),
        }

    def __init__(self, *args, **kwargs):
        super(CouncilForm, self).__init__(*args, **kwargs)
        # اگر نیاز به تغییرات اضافی دارید، می‌توانید اینجا انجام دهید
        self.fields['date_run'].label = _('تاریخ جلسه')


class CouncilApprovalsForm(forms.ModelForm):
    class Meta:
        model = CouncilApprovals
        fields = ['title', 'file', 'positive_pole', 'bstentions_pole', 'negativ_pole']
        # council را از فیلدها حذف می‌کنیم

from django import forms
from .models import CouncilMembers

class CouncilMembersForm(forms.ModelForm):
    class Meta:
        model = CouncilMembers
        fields = ['person', 'raste_categories']
        widgets = {
            'person': forms.Select(attrs={'class': 'form-control'}),
            'raste_categories': forms.Select(attrs={'class': 'form-control'}),
        }


class FutureworkForm(forms.ModelForm):
    class Meta:
        model = Futurework
        fields = '__all__'
        widgets = {
            'person': Select2MultipleWidget(
                attrs={
                    'data-url': reverse_lazy('select2_person'),
                    'data-placeholder': 'جستجو و انتخاب افراد',
                    'style': 'width: 100%;',
                    'data-minimum-input-length': 1,
                }
            ),
        }
class DutiesOfUnitsForm(forms.ModelForm):
    class Meta:
        model = DutiesOfUnits
        fields = ['mainTask']  # حذف فیلد 'raste_categories'
        labels = {
            'mainTask': 'وظایف اصلی',
        }

from django import forms
from .models import ActivityDetails

class ActivityDetailsForm(forms.ModelForm):
    class Meta:
        model = ActivityDetails
        fields = ['microActivity', 'ratio', 'done', 'description', 'time'] 
        widgets = {
            'time': AdminJalaliDateWidget(),  # استفاده از ویجت تاریخ شمسی
           
        }

    def __init__(self, *args, **kwargs):
        super(ActivityDetailsForm, self).__init__(*args, **kwargs)
        # اگر نیاز به تغییرات اضافی دارید، می‌توانید اینجا انجام دهید
        self.fields['time'].label = _('تاریخ جلسه')

        

    def __init__(self, *args, **kwargs):
        main_task = kwargs.pop('main_task', None)  # دریافت main_task از ویو
        super().__init__(*args, **kwargs)
        if main_task:
            self.main_task = main_task  # نگه‌داری main_task برای ذخیره



class EvaluationForm(forms.ModelForm):
    class Meta:
        model = Evaluation
        fields = ['value_choices', 'time', 'description']
        
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        # تنظیمات اضافی فرم در صورت نیاز
