from django import forms
from .models import *
from jalali_date.fields import JalaliDateField, SplitJalaliDateTimeField
from jalali_date.widgets import AdminJalaliDateWidget, AdminSplitJalaliDateTime

class PostForm(forms.ModelForm):
    class Meta:
        model = Post
        fields = ['author', 'category', 'title', 'content', 'poster', 'published_date']
        widgets = {
            'published_date': AdminJalaliDateWidget(),  # استفاده از ویجت تاریخ شمسی
           
        }

        def __init__(self, *args, **kwargs):
            super(PostForm, self).__init__(*args, **kwargs)
        # اگر نیاز به تغییرات اضافی دارید، می‌توانید اینجا انجام دهید
            self.fields['date_run'].label = _('تاریخ انتشار')


class CategoryForm(forms.ModelForm):
    class Meta:
        model = Category
        fields = ['title', 'parent']

class CommentForm(forms.ModelForm):
    class Meta:
        model = Comment
        fields = '__all__'
