from django.urls import path, include
from .views import *
from  . import views
urlpatterns = [
    path('council_list', views.council_list, name='council_list'),
    path('council_detail/<int:council_id>/', views.council_detail, name='council_detail'),
 
    path('add/', views.council_add, name='council_add'),
    path('edit/<int:pk>/', views.council_edit, name='council_edit'),
    path('delete/<int:pk>/', CouncilDeleteView.as_view(), name='council_delete'),
    path('approvals/<int:council_id>/', views.council_approvals, name='council_approvals'),
    path('create_approval/<int:council_id>/', CouncilApprovalsCreateView.as_view(), name='approvals_create'),
    path('approvals/update/<int:pk>/', CouncilApprovalsUpdateView.as_view(), name='approvals_update'),
    path('approvals/delete/<int:pk>/', CouncilApprovalsDeleteView.as_view(), name='approvals_delete'),
    path('council_members', CouncilMembersListView.as_view(), name='council_members_list'),
    path("export_members/", export_selected_members, name="council_members_export"),

    path('profile_view/<int:person_id>', test, name='1'),
    path('council_members/create/', CouncilMembersCreateView.as_view(), name='council_members_create'),
    path('council_members/<int:pk>/update/', CouncilMembersUpdateView.as_view(), name='council_members_update'),
    path('council_members/<int:pk>/delete/', CouncilMembersDeleteView.as_view(), name='council_members_delete'),
    path('futurework/', FutureworkListView.as_view(), name='futurework_list'),
    path('futurework/create/', FutureworkCreateView.as_view(), name='futurework_create'),
    path('futurework/update/<int:pk>/', FutureworkUpdateView.as_view(), name='futurework_update'),
    path('futurework/delete/<int:pk>/', FutureworkDeleteView.as_view(), name='futurework_delete'),
    path('ajax/load-titles/', views.load_titles, name='ajax_load_titles'),  
    path('search-persons/', views.search_persons, name='search_persons'),
    path('search_councils/', search_councils, name='search_councils'),
    
    
    #اضافه کردن وضایف اصلی واحد
    path('duties/create/<str:category>/', DutiesOfUnitsCreateView.as_view(), name='duties_of_units_create'),
    path('<int:pk>/update/', DutiesOfUnitsUpdateView.as_view(), name='duties_of_units_update'),
    path('<int:pk>/delete/', DutiesOfUnitsDeleteView.as_view(), name='duties_of_units_delete'),
    path('duties/<int:main_task_id>/activities/', views.activity_details_list, name='activity_details_list'),
    path('duties/<int:main_task_id>/activities/create/', views.activity_details_create, name='activity_details_create'),
    path('activities/<int:pk>/update/', views.activity_details_update, name='activity_details_update'),
    path('activities/<int:pk>/delete/', views.activity_details_delete, name='activity_details_delete'),
    path('activity/<int:pk>/done/', views.activity_done, name='activity_done'),
    path('activity/<int:pk>/not_done/', views.activity_not_done, name='activity_not_done'),
    path('duties/categories/', views.duties_by_categories_list, name='duties_by_categories_list'),
    path('duties/<str:category>/', views.duties_and_activities_by_category, name='duties_and_activities_by_category'),
    path('notifications/', views.notifications_view, name='notifications'),
    path('futurework/mark_as_done/<int:futurework_id>/', views.mark_as_done, name='mark_as_done'),
    path('futurework/mark_as_in_progress/<int:futurework_id>/', views.mark_as_in_progress, name='mark_as_in_progress'),

    path('mark_futurework_read/<int:futurework_id>/', views.mark_futurework_read, name='mark_futurework_read'),
    path('notifications/<int:notification_id>/submit-evaluation/', views.submit_evaluation, name='submit_evaluation'),
    path('history/', history_dashboard, name='history_dashboard'),

    path('my-duties/', MyDutiesView.as_view(), name='my_duties'),
    path('same-raste-users/', SameRasteUsersView.as_view(), name='same_raste_users'),
    path('evaluations/', evaluations_view, name='evaluations'),


    path('reportcard_unit/categories/', views.reportcard_unit, name='reportcard_unit'),
    path('reportcard_unit/<str:category>/', views.reportcard_unit_by_category, name='reportcard_unit_by_category'),
    path('reset_activity_details/', views.reset_activity_details, name='reset_activity_details'),


    path('reportcard_unit/categories/history', views.reportcard_unit_history, name='reportcard_unit_history'),
    path('reportcard_unit_history/<str:category>/', views.reportcard_unit_by_category_history, name='reportcard_unit_by_category_history'),

    # path('how/' , views.reset_all_activities )

]
