from django.contrib import admin
from .models import *
from .forms import *
admin.site.register(Evaluation)
admin.site.register(CouncilMembers)


admin.site.register(Notification)

class CouncilApprovalsInline(admin.TabularInline):
    model = CouncilApprovals


class FutureworkInline(admin.TabularInline):
    model = Futurework


@admin.register(Council)
class CouncilAdmin(admin.ModelAdmin):
    form = CouncilForm  # فرم اختصاصی برای ادمین
    inlines = [CouncilApprovalsInline, FutureworkInline]

from django.contrib import admin
from .models import DutiesOfUnits, ActivityDetails

class ActivityDetailsInline(admin.TabularInline):  # یا از admin.StackedInline استفاده کنید
    model = ActivityDetails
    extra = 1  # تعداد خطوط خالی اضافی برای ورود داده جدید
    verbose_name = "ریزفعالیت"
    verbose_name_plural = "ریزفعالیت‌ها"

@admin.register(DutiesOfUnits)
class DutiesOfUnitsAdmin(admin.ModelAdmin):
    list_display = ('raste_categories', 'mainTask')
    search_fields = ('raste_categories', 'mainTask')
    inlines = [ActivityDetailsInline]
