from django.shortcuts import render, redirect , get_object_or_404
from django.views.generic import ListView, DetailView
from django.http import HttpResponse , JsonResponse
from .models import *
from .forms import *
from django.views.decorators.csrf import csrf_protect , csrf_exempt
from django.shortcuts import render, get_object_or_404, redirect
from django.http import HttpResponseForbidden
from django.contrib.auth.decorators import login_required
class PostListView(ListView):
    model = Post
    template_name = 'post_list.html'
    context_object_name = 'posts'

    def get_queryset(self):
        queryset = super().get_queryset()

        # افزایش تعداد بازدید هر پست
        for post in queryset:
            post.view_count += 1
            post.save()

        return queryset
    


class PostDetailView(DetailView):
    model = Post
    template_name = 'post_detail.html'
    context_object_name = 'post'

    def get_object(self, queryset=None):
        post = super().get_object(queryset)
        post.view_count += 1  # افزایش تعداد بازدیدها
        post.save()  # ذخیره تغییرات
        return post
    

# ویو برای ویرایش مقاله
def edit_post(request, pk):
    post = get_object_or_404(Post, pk=pk)
       
    if request.method == "POST":
        form = PostForm(request.POST, request.FILES, instance=post)
        if form.is_valid():
            form.save()
            messages.warning(request, ' پست  با موفقیت ویرایش شد.' )

            return redirect('post-list')
    else:
        form = PostForm(instance=post)
    
    return render(request, 'create_post.html', {'form': form})

# ویو برای حذف مقاله
def delete_post(request, pk):
    post = get_object_or_404(Post, pk=pk)
       
    if request.method == "POST":
        post.delete()
        messages.error(request, 'پست با موفقیت حذف شد.', extra_tags='danger')

        return redirect('post-list')
    
    return render(request, 'post_confirm_delete.html', {'post': post})

# فرم ایجاد مقاله
from django.shortcuts import render, get_object_or_404, redirect
from django.contrib import messages
from .models import Post
from .forms import PostForm, CategoryForm

def create_post(request, post_id=None):
    # بررسی ویرایش یا ایجاد
    if post_id:
        post = get_object_or_404(Post, id=post_id)
        form = PostForm(request.POST or None, request.FILES or None, instance=post)
    else:
        form = PostForm(request.POST or None, request.FILES or None)
    
    # فرم دسته‌بندی
    category_form = CategoryForm(request.POST or None)

    # مدیریت ارسال فرم
    if request.method == 'POST':
        if 'submit_post' in request.POST and form.is_valid():
            form.save()

            messages.success(request, "پست با موفقیت ذخیره شد!")
            return redirect('post-list')  # هدایت به لیست پست‌ها
        
        if 'submit_category' in request.POST and category_form.is_valid():
            category_form.save()
            messages.success(request, "دسته‌بندی جدید با موفقیت اضافه شد!")
            return redirect(request.path)  # صفحه را دوباره بارگذاری کنید

    context = {
        'form': form,
        'category_form': category_form,
    }
    return render(request, 'create_post.html', context)


from django.http import JsonResponse, HttpResponseRedirect
from django.urls import reverse

def create_category_ajax(request):
    if request.method == 'POST':
        form = CategoryForm(request.POST)
        if form.is_valid():
            category = form.save()
            return HttpResponseRedirect(reverse('create-post'))
        else:
            return JsonResponse({'success': False, 'errors': form.errors})
    return JsonResponse({'success': False, 'error': 'Invalid request method'})

from django.shortcuts import get_object_or_404
from django.http import JsonResponse
from .models import Category
from django.views.decorators.csrf import csrf_exempt

@csrf_exempt
def delete_category(request, category_id):
    if request.method == 'DELETE':
        category = get_object_or_404(Category, id=category_id)
        category.delete()
        return JsonResponse({'success': True})
    return JsonResponse({'success': False, 'error': 'Invalid request method'})

# views.py
from django.shortcuts import render, get_object_or_404, redirect
from .models import Category

def category_management(request):
    categories = Category.objects.all()

    if request.method == "POST":
        category_id = request.POST.get("category_id")
        category = get_object_or_404(Category, id=category_id)
        category.delete()
        return redirect("category_management")  # بازگشت به همین صفحه پس از حذف

    return render(request, "category_management.html", {"categories": categories})

# نمایش لیست دسته‌بندی‌ها
class CategoryListView(ListView):
    model = Category
    template_name = 'category_list.html'
    context_object_name = 'categories'
from django.http import JsonResponse
from django.views.decorators.csrf import csrf_exempt
from .models import Post
from django.shortcuts import get_object_or_404, redirect
from .models import Post

def like_post(request, post_id):
    post = get_object_or_404(Post, id=post_id)
    post.like_count += 1
    post.save()
    return redirect('post-list')  # یا هر صفحه‌ای که می‌خواهید پس از لایک نمایش داده شود

def increment_visit(request, post_id):
    post = get_object_or_404(Post, pk=pk)
    post.visitCount += 1  # افزایش تعداد بازدید
    post.save()  # ذخیره تغییرات در دیتابیس
    return render(request, 'post_detail.html', {'post': post})




from django.http import JsonResponse
from .models import Person

def search_persons(request):
    query = request.GET.get('q', '')
    if query:
        # فیلتر بر اساس نام و نام خانوادگی از مدل User
        persons = Person.objects.filter(user__first_name__icontains=query) | Person.objects.filter(user__last_name__icontains=query)
    else:
        persons = Person.objects.none()

    # ارسال داده‌ها به صورت JSON
    data = [{'id': person.id, 'text': f"{person.user.first_name} {person.user.last_name}"} for person in persons]
    return JsonResponse(data, safe=False)
