# Generated by Django 4.2 on 2025-02-12 14:19

import ckeditor.fields
from django.db import migrations, models
import django.db.models.deletion
import django_jalali.db.models
import jdatetime


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('persons', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100, verbose_name='عنوان')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='blog.category')),
            ],
            options={
                'verbose_name': 'دسته بندی',
                'verbose_name_plural': 'دسته بندی ها',
            },
        ),
        migrations.CreateModel(
            name='Post',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100, verbose_name='عنوان')),
                ('content', ckeditor.fields.RichTextField(blank=True, null=True, verbose_name='محتوا')),
                ('poster', models.ImageField(blank=True, null=True, upload_to='poster', verbose_name='پوستر')),
                ('thumbnail', models.ImageField(blank=True, null=True, upload_to='thumbnail', verbose_name='تامنیل')),
                ('published_date', django_jalali.db.models.jDateField(blank=True, default=jdatetime.datetime.now, null=True, verbose_name='تایم انتشار')),
                ('like_count', models.PositiveIntegerField(default=0, verbose_name='تعداد لایک')),
                ('view_count', models.PositiveIntegerField(default=0)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='persons.person', verbose_name='نویسنده')),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='blog.category', verbose_name='دسته بندی')),
            ],
            options={
                'verbose_name': 'مقاله',
                'verbose_name_plural': 'مقاله ها',
            },
        ),
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('author', models.CharField(max_length=100, verbose_name='نویسنده')),
                ('content', ckeditor.fields.RichTextField(blank=True, null=True, verbose_name='محتوا')),
                ('published_date', django_jalali.db.models.jDateField(verbose_name='تایم انتشار')),
                ('post', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comments', to='blog.post')),
                ('response', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='blog.comment', verbose_name='پاسخ کامنت')),
            ],
            options={
                'verbose_name': 'کامنت',
                'verbose_name_plural': 'کامنت ها',
            },
        ),
    ]
